import argparse
parser = argparse.ArgumentParser()
parser.add_argument('--model', type=str, required=True)
args = parser.parse_args()

from utils import *
for pt_name, pt, pt_col, fn_cols, cols_name in [
    ("ACADBCBD", (0,2,0,3,1,2,1,3,), ("green", "red", "blue", "gray"), fn_colors_random_slow, "rand",),
    ("AB", (0,1,), ("green", "red",), fn_colors_random_slow, "rand",),
    ("AA", (0,0,), ("green", "red",), fn_colors_random_slow, "rand",),
    ("AA (fixed)", (0,0,), ("green", "red",), fn_colors_fixed, "fixed",),
    ]:
    w = len(pt)
    output_filename = f'16_{args.model.split("/")[1]}_{cols_name}{pt_name}_ppl.pkl'
    print(args, output_filename)
    data = sweep_for_watermark_detection(
        {
            "config": {
                "log": True,
                "verbose": False,
                "data.file_name": "01_wikitext2.json",
                "tokenizer.max_length": 16,
                "tokenizer.truncation": True,
                "tokenizer.truncation_side": "right",
                "tokenizer.padding_side": "left",
                "model.name": args.model,
                "model.token_count": 64,
                # "model.do_sample": True,
                # "model.num_beams": 4,
                "model.output_scores": False,
                "watermark.colors": pt_col,
                "watermark.color_pattern": pt,
                "watermark.fn_colors": fn_cols,
                "watermark.fn_pattern": fn_pattern_using_prev,
                "detection.window": w,
                "detection.target_t1": .15,
            },
        },
        data_key="watermark.delta",
        data_vals = [(str(f), f,) for f in reversed([0, .25, .5, .75, 1, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 3.5, 4.0, 4.5, 5.0, 5.5, 6.0])],
        batch_size=128, batch_count=1,
    )

    with open(output_filename, 'wb') as file:
        pickle.dump(data, file)

"""
for model in "meta-llama/Llama-2-7b-hf" "facebook/opt-1.3b"; do python 16_exp_wm_detection_vs_ppl.py --model="$model"; done
"""